<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Inquiry extends Model 
{

    protected $table = 'inquiries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('Company', 'company_id');
    }

    public function notification_recipients()
    {
        return $this->hasMany('App\Models\Notification_Recipients', 'inquiry_id');
    }

    public function inquiry_milestones()
    {
        return $this->hasMany('App\Models\InquiryMilestone', 'inquiry_id');
    }

    public function inquiry_answers()
    {
        return $this->hasMany('App\Models\InquiryAnswer', 'inquiry_id');
    }

}